<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Remotos extends BaseController
{
	public function __construct(){
 		$this->regionPais = new \App\Models\RegionPaisModel();
        $this->regionDepartamento = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito = new \App\Models\RegionDistritoModel();
        
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraSubareaDelegaciones = new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        
        $this->estructuraResponsablesDireccion = new \App\Models\EstructuraDireccionResponsableModel();
        $this->estructuraResponsablesArea = new \App\Models\EstructuraAreaResponsableModel();
        $this->estructuraResponsablesSubarea = new \App\Models\EstructuraSubareaResponsableModel();
	}

    /************************* REGIÓN PAÍS ************************************/
    
	public function listadoRegionPais()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoPaises = $this->regionPais->where("Estado", "A")->findAll();
        
        $paises=array();

		if (!empty($listadoPaises)) {
            foreach ($listadoPaises as $items) {
                $paises[] = array(
					'id'    => (string) $items['IDPais'],
         	        'text'  => (string) $items['Pais'],
                );
            }

            $resultado = array(
				'listadoPaises' => json_encode($paises)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	/**************************************************************************/
	
    /********************* REGIÓN DEPARTAMENTO ********************************/
    
	public function listadoRegionDepartamento()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idPais = $this->request->getPost('idPais');

        if($idPais == 'TOTAL')
        {
            $listadoDepartamentos = $this->regionDepartamento->where("Estado", "A")->findAll();
        }
        else
        {
            $whereDepartamentos = array(
                'IDPais' => $idPais,
                'Estado' => "A"
            );
            $listadoDepartamentos = $this->regionDepartamento->where($whereDepartamentos)->findAll();
        }
        
        $departamentos=array();

		if (!empty($listadoDepartamentos)) {
            foreach ($listadoDepartamentos as $items) {
                $departamentos[] = array(
					'id'    => (string) $items['IDDepartamento'],
         	        'text'  => (string) $items['Departamento'],
                );
            }

            $resultado = array(
				'listadoDepartamentos' => json_encode($departamentos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	/**************************************************************************/
	
    /*********************** REGIÓN PROVINCIA *********************************/
    
	public function listadoRegionProvincia()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idDepartamento = $this->request->getPost('idDepartamento');

        if($idDepartamento == 'TOTAL')
        {
            $listadoProvincias = $this->regionProvincia->where("Estado", "A")->findAll();
        }
        else
        {
            $whereProvincias = array(
                'IDDepartamento' => $idDepartamento,
                'Estado' => "A"
            );
            $listadoProvincias = $this->regionProvincia->where($whereProvincias)->findAll();
        }
        
        $provincias = array();

		if (!empty($listadoProvincias)) {
            foreach ($listadoProvincias as $items) {
                $provincias[] = array(
					'id'    => (string) $items['IDProvincia'],
         	        'text'  => (string) $items['Provincia'],
                );
            }

            $resultado = array(
				'listadoProvincias' => json_encode($provincias)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	/**************************************************************************/
	
    /************************ REGIÓN DISTRITO *********************************/
    
	public function listadoRegionDistrito()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idProvincia = $this->request->getPost('idProvincia');

        if($idProvincia == 'TOTAL')
        {
            $listadoDistritos = $this->regionDistrito->where("Estado", "A")->findAll();
        }
        else
        {
            $whereDistritos = array(
                'IDProvincia' => $idProvincia,
                'Estado' => "A"
            );
            $listadoDistritos = $this->regionDistrito->where($whereDistritos)->findAll();
        }
        
        $distritos = array();

		if (!empty($listadoDistritos)) {
            foreach ($listadoDistritos as $items) {
                $distritos[] = array(
					'id'    => (string) $items['IDDistrito'],
         	        'text'  => (string) $items['Distrito'],
                );
            }

            $resultado = array(
				'listadoDistritos' => json_encode($distritos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	/**************************************************************************/
	
    /**************************** MONEDAS *************************************/
    
	public function listadoMonedas()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoMonedas = array(
            "PEN" => array(
                "NOMBRE" => "Soles",
                "SIMBOLO" => "S/"
                ),
            "USD" => array(
                "NOMBRE" => "Dólares Americanos",
                "SIMBOLO" => "$"
                ),
            "EUR" => array(
                "NOMBRE" => "Euros",
                "SIMBOLO" => "€"
                )
        );
        
        $monedas = array();

		if (!empty($listadoMonedas)) {
    //         foreach ($listadoDistritos as $items) {
    //             $distritos[] = array(
				// 	'id'    => (string) $items['IDDistrito'],
    //      	        'text'  => (string) $items['Distrito'],
    //             );
    //         }
                
            foreach ($listadoMonedas as $key => $items) {
                $monedas[] = array(
					'id'    => (string) $key,
         	        'text'  => (string) "(".$items['SIMBOLO'].") ".$items['NOMBRE'],
         	        'simbolo'   => (string) $items['SIMBOLO']
                );
            }
            
            $resultado = array(
				'listadoMonedas' => json_encode($monedas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	/**************************************************************************/
	
    /************************** ESTRUCTURA DIRECCIÓN **************************/
    
	public function listadoDireccionesEstructura()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoDirecciones = $this->estructuraDirecciones->findAll();
        
        $direcciones=array();

		if (!empty($listadoDirecciones)) {
            foreach ($listadoDirecciones as $items) {
                $direcciones[] = array(
					'id' => (string) $items['IDDireccion'],
         	        'text' => (string) $items['Direccion'],
                );
            }

            $resultado = array(
				'listadoDirecciones' => json_encode($direcciones)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function listadoResponsablesDireccionEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idDireccion = $this->request->getPost('idDireccion');

        // if($idArea == 'TOTAL')
        // {
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->findAll();
        // }
        // else
        // {
        //     $whereSubareas = array('IDArea' => $idArea);
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->where($whereSubareas)->findAll();
        // }
        
        $listadoResponsables = $this->estructuraResponsablesDireccion->listadoResponsablesDireccion($idDireccion);
        
        $responsables=array();

		if (!empty($listadoResponsables)) {
            foreach ($listadoResponsables as $items) {
                $responsables[] = array(
					'id'    => (string) $items['IDResponsable'],
         	        'text'  => (string) ucwords(mb_strtolower($items['MatriculaResponsable'].' | '.$items['NombreResponsable']))
                );
            }

            $resultado = array(
				'listadoResponsables' => json_encode($responsables)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
    }
    
	/**************************************************************************/
	
    /**************************** ESTRUCTURA ÁREAS ****************************/
    
	public function listadoAreasEstructura()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idDireccion = $this->request->getPost('idDireccion');

        if($idDireccion == 'TOTAL')
        {
            $listadoAreas = $this->estructuraAreas->findAll();
        }
        else
        {
            $whereAreas = array('IDDireccion' => $idDireccion);
            $listadoAreas = $this->estructuraAreas->where($whereAreas)->findAll();
        }
        
        $areas=array();

		if (!empty($listadoAreas)) {
            foreach ($listadoAreas as $items) {
                $areas[] = array(
					'id' => (string) $items['IDArea'],
         	        'text' => (string) $items['Area'],
                );
            }

            $resultado = array(
				'listadoAreas' => json_encode($areas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}
	
    public function listadoResponsablesAreaEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idArea = $this->request->getPost('idArea');
		
        // if($idArea == 'TOTAL')
        // {
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->findAll();
        // }
        // else
        // {
        //     $whereSubareas = array('IDArea' => $idArea);
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->where($whereSubareas)->findAll();
        // }
        
        $listadoResponsables = $this->estructuraResponsablesArea->listadoResponsablesArea($idArea);
        
        $responsables=array();

		if (!empty($listadoResponsables)) {
            foreach ($listadoResponsables as $items) {
                $responsables[] = array(
					'id'    => (string) $items['IDResponsable'],
         	        'text'  => (string) ucwords(mb_strtolower($items['MatriculaResponsable'].' | '.$items['NombreResponsable']))
                );
            }

            $resultado = array(
				'listadoResponsables' => json_encode($responsables)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
    }
    
	/**************************************************************************/
	
    /*************************** ESTRUCTURA SUBÁREAS **************************/
    
    public function listadoSubareasEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idArea = $this->request->getPost('idArea');

        if($idArea == 'TOTAL')
        {
            $listadoSubareas = $this->estructuraSubareas->findAll();
        }
        else
        {
            $whereSubareas = array('IDArea' => $idArea);
            $listadoSubareas = $this->estructuraSubareas->where($whereSubareas)->findAll();
        }
        
        $subareas=array();

		if (!empty($listadoSubareas)) {
            foreach ($listadoSubareas as $items) {
                $subareas[] = array(
					'id' => (string) $items['IDSubarea'],
         	        'text' => (string) $items['Subarea'],
                );
            }

            $resultado = array(
				'listadoSubareas' => json_encode($subareas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
    public function listadoResponsablesSubareaEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idSubarea = $this->request->getPost('idSubarea');

        // if($idArea == 'TOTAL')
        // {
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->findAll();
        // }
        // else
        // {
        //     $whereSubareas = array('IDArea' => $idArea);
        //     $listadoSubareas = $this->estructuraResponsablesSubarea->where($whereSubareas)->findAll();
        // }
        
        $listadoResponsables = $this->estructuraResponsablesSubarea->listadoResponsablesSubarea($idSubarea);
        
        $responsables=array();

		if (!empty($listadoResponsables)) {
            foreach ($listadoResponsables as $items) {
                $responsables[] = array(
					'id'    => (string) $items['IDResponsable'],
         	        'text'  => (string) ucwords(mb_strtolower($items['MatriculaResponsable'].' | '.$items['NombreResponsable']))
                );
            }

            $resultado = array(
				'listadoResponsables' => json_encode($responsables)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
    }
    
	/**************************************************************************/
	
    /******************* ESTRUCTURA SUBÁREAS - DELEGACIONES *******************/
    
    public function listadoDelegacionEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idSubarea = $this->request->getPost('idSubarea');

        if($idSubarea == 'TOTAL')
        {
            $listadoDelegaciones = $this->estructuraDelegaciones->findAll();
        }
        else
        {
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea($idSubarea);
        }
        
        $delegaciones=array();

		if (!empty($listadoDelegaciones)) {
            foreach ($listadoDelegaciones as $items) {
                $delegaciones[] = array(
					'id' => (string) $items['IDDelegacion'],
         	        'text' => (string) $items['CC'].'-'.$items['LN'].' | '.$items['Delegacion'],
         	        'cc' => $items['CC'],
         	        'ln' => $items['LN']
                );
            }

            $resultado = array(
				'listadoDelegaciones' => json_encode($delegaciones)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}
		
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DELEGACIONES ************************/
    
    public function listadoEstructuraDelegacion()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idDelegacion = $this->request->getPost('idDelegacion');

        $listadoEstructura = $this->estructuraSubareaDelegaciones->listarEstructuraXDelegacion($idDelegacion);
        
        $direcciones = array();
        $areas = array();
        $subareas = array();
        $correos = array();
        $global = array();

		if (!empty($listadoEstructura)) {
            foreach ($listadoEstructura as $items) {
                
                if(!in_array($items['IDDireccion'], array_column($direcciones, 'id')))
                {
                    $direcciones[] = array(
    					'id' => (string) $items['IDDireccion'],
             	        'text' => (string) $items['Direccion']
                    );
                }
                
                if(!in_array($items['IDArea'], array_column($areas, 'id')))
                {
                    $areas[] = array(
    					'id' => (string) $items['IDArea'],
             	        'text' => (string) $items['Area'],
                    );
                }
                
                if(!in_array($items['IDSubarea'], array_column($subareas, 'id')))
                {
                    $subareas[] = array(
    					'id' => (string) $items['IDSubarea'],
             	        'text' => (string) $items['Subarea'],
                    );
                }
                
                if($items['Correo'] != '' && $items['Correo'] != '')
                {
                    if(!in_array($items['Correo'], array_column($correos, 'text')))
                    {
                        $correos[] = array(
        					'id' => (string) $items['IDSubarea'].$items['IDArea'].$items['IDDireccion'],
                 	        'text' => (string) $items['Correo'],
        					'idsubarea' => (string) $items['IDSubarea'],
        					'idarea' => (string) $items['IDArea'],
        					'iddireccion' => (string) $items['IDDireccion'],
                        );
                    }
                }
                
                $global[] = array(
					'id'            => (string) $items['IDSubarea'],
         	        'text'          => (string) $items['Subarea'].' | '.$items['Area'].' | '.$items['Direccion'],
					'idsubarea'     => (string) $items['IDSubarea'],
					'idarea'        => (string) $items['IDArea'],
					'iddireccion'   => (string) $items['IDDireccion']
                );
            }

            $resultado = array(
				'listadoDirecciones' => json_encode($direcciones),
				'listadoAreas' => json_encode($areas),
				'listadoSubareas' => json_encode($subareas),
				'listadoCorreos' => json_encode($correos),
				'listadoGlobal' => json_encode($global)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}
		
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DEPARTAMENTAL ************************/
    
    public function exportarEstructuraDepartamental()
    {
        $listadoEstructura = $this->estructuraSubareaDelegaciones->listarEstructuraXDelegacion("");
        
        $filename = "estructura_departamental.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Dirección"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Delegación")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoEstructura as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['Direccion']),
                WriterEntityFactory::createCell($item['Area']),
                WriterEntityFactory::createCell($item['Subarea']),
                WriterEntityFactory::createCell($item['CC']),
                WriterEntityFactory::createCell($item['LN']),
                WriterEntityFactory::createCell($item['Delegacion'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
    
	/**************************************************************************/
	
	
}